/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx.ft4222;

import android.util.Log;
import com.ftdi.j2xx.FT_Device;
import com.ftdi.j2xx.ft4222.FT_4222_Device;
import com.ftdi.j2xx.ft4222.SPI_MasterCfg;
import com.ftdi.j2xx.ft4222.chiptop_mgr;
import com.ftdi.j2xx.interfaces.SpiSlave;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FT_4222_Spi_Slave
implements SpiSlave {
    private FT_4222_Device mFT4222Device;
    private FT_Device mFTDevice;
    private Lock m_pDevLock;
    private static final String TAG = "FTDI_Device::";

    public FT_4222_Spi_Slave(FT_4222_Device pDevice) {
        this.mFT4222Device = pDevice;
        this.mFTDevice = pDevice.mFtDev;
        this.m_pDevLock = new ReentrantLock();
    }

    public int init() {
        int status = 0;
        chiptop_mgr chipStatus = this.mFT4222Device.mChipStatus;
        SPI_MasterCfg config = this.mFT4222Device.mSpiMasterCfg;
        int ioLine = 1;
        int clock = 2;
        int cpol = 0;
        int cpha = 0;
        int ss = 0;
        byte ssoMap = 1;
        int fun = 4;
        config.ioLine = ioLine;
        config.clock = clock;
        config.cpol = cpol;
        config.cpha = cpha;
        config.ssoMap = ssoMap;
        this.m_pDevLock.lock();
        this.mFT4222Device.cleanRxData();
        if (this.mFTDevice.VendorCmdSet(33, 0x42 | config.ioLine << 8) < 0) {
            status = 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x44 | config.clock << 8) < 0) {
            status = 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x45 | config.cpol << 8) < 0) {
            status = 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x46 | config.cpha << 8) < 0) {
            status = 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x43 | ss << 8) < 0) {
            status = 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x48 | config.ssoMap << 8) < 0) {
            status = 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 5 | fun << 8) < 0) {
            status = 4;
        }
        this.m_pDevLock.unlock();
        chipStatus.function = (byte)4;
        return status;
    }

    public int getRxStatus(int[] pRxSize) {
        if (pRxSize == null) {
            return 1009;
        }
        int status = this.check();
        if (status != 0) {
            return status;
        }
        this.m_pDevLock.lock();
        int ret = this.mFTDevice.getQueueStatus();
        this.m_pDevLock.unlock();
        if (ret >= 0) {
            pRxSize[0] = ret;
            status = 0;
        } else {
            pRxSize[0] = -1;
            status = 4;
        }
        return status;
    }

    public int read(byte[] buffer, int bufferSize, int[] sizeOfRead) {
        int status = 0;
        this.m_pDevLock.lock();
        if (this.mFTDevice == null || !this.mFTDevice.isOpen()) {
            this.m_pDevLock.unlock();
            return 3;
        }
        int ret = this.mFTDevice.read(buffer, bufferSize);
        this.m_pDevLock.unlock();
        sizeOfRead[0] = ret;
        status = ret >= 0 ? 0 : 4;
        return status;
    }

    public int write(byte[] buffer, int bufferSize, int[] sizeTransferred) {
        int status = 0;
        if (sizeTransferred == null || buffer == null) {
            return 1009;
        }
        status = this.check();
        if (status != 0) {
            return status;
        }
        if (bufferSize > 512) {
            return 1010;
        }
        this.m_pDevLock.lock();
        sizeTransferred[0] = this.mFTDevice.write(buffer, bufferSize);
        this.m_pDevLock.unlock();
        if (sizeTransferred[0] != bufferSize) {
            Log.e((String)TAG, (String)("Error write =" + bufferSize + " tx=" + sizeTransferred[0]));
            status = 4;
        }
        return status;
    }

    private int check() {
        chiptop_mgr chipStatus = this.mFT4222Device.mChipStatus;
        if (chipStatus.function != 4) {
            return 1003;
        }
        return 0;
    }

    public int reset() {
        int verderReset = 0;
        int status = 0;
        this.m_pDevLock.lock();
        if (this.mFTDevice.VendorCmdSet(33, 0x4A | verderReset << 8) < 0) {
            status = 4;
        }
        this.m_pDevLock.unlock();
        return status;
    }

    public int setDrivingStrength(int clkStrength, int ioStrength, int ssoStregth) {
        int status = 0;
        chiptop_mgr chipStatus = this.mFT4222Device.mChipStatus;
        if (chipStatus.function != 3 && chipStatus.function != 4) {
            return 1003;
        }
        int actual_strength = clkStrength << 4;
        actual_strength |= ioStrength << 2;
        int verderFun = chipStatus.function == 3 ? 3 : 4;
        this.m_pDevLock.lock();
        if (this.mFTDevice.VendorCmdSet(33, 0xA0 | (actual_strength |= ssoStregth) << 8) < 0) {
            status = 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 5 | verderFun << 8) < 0) {
            status = 4;
        }
        this.m_pDevLock.unlock();
        return status;
    }
}

